package gov.va.vamf.scheduling.direct.datalayer.eligibility;

import gov.va.vamf.scheduling.direct.domain.CoreSetting;
import gov.va.vamf.scheduling.direct.domain.DirectBookingEligibilityCriteria;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

@Service
public class DirectBookingEligibilityCriteriaService {

    private final DirectBookingEligibilityCriteriaRepository directBookingEligibilityCriteriaRepository;

    @Autowired
    public DirectBookingEligibilityCriteriaService(
            final DirectBookingEligibilityCriteriaRepository directBookingEligibilityCriteriaRepository
    ) {
        this.directBookingEligibilityCriteriaRepository = directBookingEligibilityCriteriaRepository;
    }

    public DirectBookingEligibilityCriteria retrieveDirectBookingEligibilityCriteria(String siteCode) {
        DirectBookingEligibilityCriteria criteria = directBookingEligibilityCriteriaRepository.findById(siteCode);
        return criteria;
    }

    public Iterable<DirectBookingEligibilityCriteria> retrieveDirectBookingEligibilityCriteriaByInstitutionCode(Collection<String> institutionCodes) {
        return directBookingEligibilityCriteriaRepository.findAll(institutionCodes);
    }

    /**
     * Fetches one or more {@link gov.va.vamf.scheduling.direct.domain.DirectBookingEligibilityCriteria}
     * @param ids the DirectBookingEligibilityCriteria objects to fetch
     * @return a <code>Map</code> of ids to the requested criteria
     */
    public Map<String, DirectBookingEligibilityCriteria> fetchAsMap(final Collection<String> ids) {
        final Map<String, DirectBookingEligibilityCriteria> criteriaMap = new HashMap<>();

        final Iterable<DirectBookingEligibilityCriteria> criteria = directBookingEligibilityCriteriaRepository.findAll(ids);

        for (final DirectBookingEligibilityCriteria directBookingEligibilityCriteria : criteria) {
            criteriaMap.put(directBookingEligibilityCriteria.getId(), directBookingEligibilityCriteria);
        }

        return criteriaMap;
    }

    /**
     * Fetches a particular set of settings from a {@link gov.va.vamf.scheduling.direct.domain.DirectBookingEligibilityCriteria}
     * @param criteriaId the DirectBookingEligibility to fetch
     * @param settingId the settings to fetch
     * @return
     */
    public Optional<CoreSetting> fetchSettings(final String criteriaId, final String settingId) {
        final DirectBookingEligibilityCriteria criteria = retrieveDirectBookingEligibilityCriteria(criteriaId);

        if (criteria == null) {
            return Optional.empty();
        }

        final Optional<CoreSetting> settings = criteria.getSetting(settingId);
        return settings;
    }

    /**
     * Fetches a particular set of settings from one or more {@link gov.va.vamf.scheduling.direct.domain.DirectBookingEligibilityCriteria}
     * @param criteriaIds the DirectBookingEligibility objects to fetch
     * @param settingId the settings to fetch
     * @return a <code>Map</code> of ids to the requested critieria
     */
    public Map<String, CoreSetting> fetchSettingAsMap(final Collection<String> criteriaIds, final String settingId) {
        final Map<String, CoreSetting> settingsMap = new HashMap<>();

        Iterable<DirectBookingEligibilityCriteria> criteria =
                retrieveDirectBookingEligibilityCriteriaByInstitutionCode(criteriaIds);
        for (final DirectBookingEligibilityCriteria criteriaEntry : criteria) {
            final Optional<CoreSetting> settings = criteriaEntry.getSetting(settingId);
            settings.ifPresent(new Consumer<CoreSetting>() { // TODO: switch to lambda
                @Override
                public void accept(CoreSetting coreSetting) {
                    settingsMap.put(criteriaEntry.getId(), coreSetting);
                }
            });
        }

        return settingsMap;
    }
}
